// DocBase Services
import { getTransResult } from '@tingwu/service';

import { iDocIDType } from '../../document.baseType';

import { docBaseAPIToLocalDataTransfer } from './docBase.dataTransfer';

/** 纪要转写 */
// 获取 转写 TransResult
export const fetchTransResultService = async (transId: iDocIDType) => {
  interface transResultAPIData {
    success: boolean;
    output: any;
  }
  const transResult: transResultAPIData = await getTransResult(`${transId}`);
  // 成功返回数据
  if (transResult.output) {
    const data = await docBaseAPIToLocalDataTransfer(
      transResult.output,
      transId,
    );
    return {
      data,
    };
  }
  // 否则返回错误码
  return {
    docErrorCode: '',
  };
};
