import { produce } from 'immer';
import { iDocumentState } from '../../document.type';

import * as docBaseActions from './docBase.actions';

// DocBase Reducers
export const docBaseReducers = {
  // 更新基础数据(纪要转写、内容盒子)
  updateDocBaseDataReducer: (
    state: iDocumentState,
    action: ReturnType<typeof docBaseActions.updateDocBaseDataAction>,
  ) => {
    const { docId, data } = action.payload;
    const docBaseData = data!;

    // 计算新数据
    const newState = produce(state, (draftState) => {
      const originModelBaseData = draftState.docBaseDataMap[docId];
      if (!originModelBaseData) {
        draftState.docBaseDataMap[docId] = docBaseData;
      } else {
        Object.keys(docBaseData).forEach((key) => {
          // eslint-disable-next-line no-prototype-builtins
          if (docBaseData.hasOwnProperty(key)) {
            draftState.docBaseDataMap[docId][key] = docBaseData[key];
          }
        });
      }
    });

    return newState;
  },
};
