import { eDocScene, eDocShareError } from '../../document.baseType';
import { fetchTransResultService } from './docBase.services';

import { docPlayerActions } from '../../docPlayer/docPlayer.operator';
import { docSpeakerActions } from '../../docSpeaker/docSpeaker.operator';
import { docTagActions } from '../../docTag/docTag.operator';
import { docTranslateActions } from '../../docTranslate/docTranslate.operator';
import { documentActions } from '../../document.operator';
import * as docBaseActions from './docBase.actions';

import { docTextPolishActions } from '../../../documentModel/docTextPolish/docTextPolish.operator';

import { docBigModelActions } from '../../../documentModel/docBigModel/docBigModel.operator';
import { delay } from '../../../utils/delay.util';

// DocBase Effects
export const docBaseEffects = {
  /** 基础纪要 */
  // 获取基础内容
  *initTransDocBaseEffect(
    action: ReturnType<typeof docBaseActions.initDocBaseAction>,
    { put, call, all }: any,
  ) {
    const { docId } = action.payload;
    let { docScene } = action.payload;
    while (true) {
      const docBaseAPIResult = (yield call(
        fetchTransResultService,
        docId,
      )) as Awaited<ReturnType<typeof fetchTransResultService>>;
      // 返回失败
      if (docBaseAPIResult.docErrorCode || !docBaseAPIResult.data) {
        // 更新公用数据错误码
        yield put(
          documentActions.updateDocumentCurtDataAction({
            docId,
            docErrorCode: docBaseAPIResult.docErrorCode as eDocShareError,
          }),
        );
        // 返回失败
        return {
          docErrorCode: docBaseAPIResult.docErrorCode,
        };
      }
      // 确认场景并更新
      const { data: transResult } = docBaseAPIResult;
      // const { fileType: docFileType } = transResult.tag;
      docScene = eDocScene.trans;

      yield put(
        documentActions.updateDocumentCurtDataAction({
          docId,
          docScene,
        }),
      ); // 更新场景
      // 更新基础数据
      yield put(
        docBaseActions.updateDocBaseDataAction({
          docId,
          docScene,
          data: transResult as any,
        }),
      );
      // 更新其他数据(以下并发获取的)
      yield all([
        // 1.初始化纪要 Tag
        put(
          docTagActions.initDocTagDataAction({
            docId,
            docScene,
            data: {
              ...transResult.tag,
              status: docBaseAPIResult.data.status,
              errorCode: docBaseAPIResult.data.errorCode,
            },
          }),
        ),
        // 2.初始化发言人数据
        put(docSpeakerActions.initDocSpeakerDataAction({ docId, docScene })),
        // 3.初始化大模型结果
        put(docBigModelActions.initDocBigModelDataAction({ docId, docScene })),
        // 4.初始化翻译数据
        put(
          docTranslateActions.initDocTranslateDataAction({ docId, docScene }),
        ),
        // 5.初始化播放器数据
        put(docPlayerActions.initDocPlayerDataAction({ docId, docScene })),
        // 6.AI原文改写数据
        put(
          docTextPolishActions.initDocTextPolishDataAction({
            docId,
            docScene,
          }),
        ),
      ]);
      if (docBaseAPIResult.data.status === 1) {
        yield delay(5000);
        continue;
      } else {
        break;
      }
    }
  },
};
