import { debounce } from 'lodash-es';
import { useCallback, useMemo } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { eDocScene } from '../document.baseType';
import { iDocumentState } from '../document.type';
import { docBaseActions } from './docBase.operator';
import { fileControlPayload } from './docBase.type';

// DocBase Hooks
const useDocBaseData = () => {
  const dispatch = useDispatch();
  // redux 取数
  const { docId, docScene, docBaseDataMap } = useSelector(
    (state: { documentModel: iDocumentState }) => ({
      docId: state.documentModel.docId!,
      docScene: state.documentModel.docScene!,
      docBaseDataMap: state.documentModel.docBaseDataMap,
    }),
  );

  // 当前文档基础数据
  const docBaseData = useMemo(() => {
    if (!docId || !docScene) return undefined;
    return docBaseDataMap[docId];
  }, [docId, docScene, docBaseDataMap]);

  // 基础数据初始化
  const initDocBaseData = useCallback(
    async (initDocId: string, _docScene: eDocScene) => {
      return await dispatch(
        docBaseActions.initDocBaseAction({
          docId: initDocId,
          docScene: _docScene,
        }),
      );
    },
    [dispatch],
  );

  return {
    // data
    docBaseData,
    initDocBaseData,
  };
};

export { useDocBaseData };
