import { ConfigProvider } from 'antd';
import { TyCss } from '@tingwu/design';
import { enableMapSet } from 'immer';
import { Provider } from 'react-redux';
import { RecoilRoot } from 'recoil';
import RecoilNexus from 'recoil-nexus';
import { store } from './dva';

import PageDetail from './pages/docASR/pageDetail';

enableMapSet();

export function rootContainer(props, opts) {
  return (
    <ConfigProvider>
      <Provider store={store}>
        <RecoilRoot {...opts}>
          <TyCss />
          <RecoilNexus />
          {/* {container} */}
          <PageDetail />
        </RecoilRoot>
      </Provider>
    </ConfigProvider>
  );
}
