import * as React from 'react';
import { render } from '@testing-library/react';
import { rootContainer } from '../app';

// Mock dependencies
jest.mock('antd', () => ({
  ConfigProvider: ({ children }: { children: React.ReactNode }) => <div>{children}</div>,
}));

jest.mock('@tingwu/design', () => ({
  TyCss: () => <div>TyCss</div>,
}));

jest.mock('react-redux', () => ({
  Provider: ({ children }: { children: React.ReactNode }) => <div>{children}</div>,
}));

jest.mock('recoil', () => ({
  RecoilRoot: ({ children }: { children: React.ReactNode }) => <div>{children}</div>,
}));

jest.mock('recoil-nexus', () => ({
  __esModule: true,
  default: () => <div>RecoilNexus</div>,
}));

jest.mock('../pages/docASR/pageDetail', () => ({
  __esModule: true,
  default: () => <div>PageDetail</div>,
}));

jest.mock('../dva', () => ({
  store: {},
}));

describe('@tingwu/summary', () => {
  it('should export rootContainer function', () => {
    expect(rootContainer).toBeDefined();
    expect(typeof rootContainer).toBe('function');
  });

  it('should render rootContainer without crashing', () => {
    const Container = rootContainer({}, {});
    const { container } = render(Container);
    expect(container).toBeTruthy();
  });
});

