const { execSync } = require('child_process');

module.exports = {
  '*.{js?(x),ts?(x)}': preTsLintCallback,
};

function preTsLintCallback() {
  try {
    // 获取git暂存区所有文件 & 过滤出个人修改过的所有 js jsx ts tsx 文件
    const filesToLint = execSync(
      `git diff --cached --name-only --diff-filter=ACM | awk '/\.(ts|tsx|js|jsx)$/ && !/\.ejs$/'`,
    )
      .toString()
      .split('\n')
      .filter((path) => path && path.length);

    // 如果有需要校验的文件，则返回 eslint 命令
    if (filesToLint.length > 0) {
      console.log('本次发生变更要校验的(tsx|ts|js|jsx)文件');
      console.log(filesToLint);
      return `eslint --quiet --no-fix ${filesToLint.join(' ')}`;
    }

    // 如果没有需要校验的文件，则返回 []
    return [];
  } catch (error) {
    return [];
  }
}
