import { UID } from "@tingwu/core";

export interface SpeakerSummary {
  uid: UID;
  content: string;
  isTextTooShort: boolean;
}

export interface DisplaySpeakerSummary extends SpeakerSummary {
  realUid: UID;
  isDeleted: boolean;
  renderedName?: string;
}

export interface SpeakerSummaryStates {
  uidMapping: Record<UID, UID>;
  summaries: SpeakerSummary[];
  displaySummaries: DisplaySpeakerSummary[];
}

export const getSpeakerSummaryInitState = (): SpeakerSummaryStates => {
  return {
    uidMapping: {},
    summaries: [],
    displaySummaries: [],
  };
};
