import { SID, UID } from "@tingwu/core";

export interface QnA {
  id: string;
  isVaild: boolean;
  question: {
    uid: UID;
    title: string;
    sids: SID[];
    sentenceInfoOfQuestion?: SentenceInfo[];
  };
  answer?: {
    uid: UID;
    uids: UID[];
    title: string;
    sids: SID[];
    isOnly: boolean;
    sentenceInfoOfAnswer?: SentenceInfo[];
  };
}

export interface QnAStates {
  qnaList: QnA[];
  displayQnaList: QnA[];
  activeQnaIndex: number | undefined;
}

export const getQnAInitState = (): QnAStates => {
  return {
    qnaList: [],
    displayQnaList: [],
    activeQnaIndex: undefined,
  };
};

export interface Question {
  qId: string;
  qQuestion: string;
  qAnswer: string;
  extensions?: {
    sentenceIdsOfAnswer: string[];
    sentenceIdsOfQuestion: string[];
    sentenceInfoOfAnswer?: SentenceInfo[];
    sentenceInfoOfQuestion?: SentenceInfo[];
  };
  qSentences?: Array<{
    qSi: number;
    qText: string;
    qUI: string;
  }>;
}

export interface SentenceInfo {
  beginTime: number;
  endTime: number;
  paragraphId: string;
  sentenceId: number;
  ui: string;
}
export interface QnaOriginData {
  questions: Question[];
}
