import React from "react";
import { useSphereState } from "../../../../components/provider";
import { QnAController } from "../../qnaController";

export interface QnaListProps {
  qnaController: QnAController;
}

export const QnaList: React.FC<QnaListProps> = props => {
  const { qnaController } = props;

  const displayQnaList = useSphereState(qnaController, "displayQnaList");
  const activeQnaIndex = useSphereState(qnaController, "activeQnaIndex");

  return (
    <div>
      <div>
        {displayQnaList?.map((qa, index) => {
          return (
            <div
              onClick={() => {
                qnaController.setActiveQnaIndex(index);
              }}
            >
              {activeQnaIndex === index ? "[active]" : null}
              Question: {qa.id} - {`${qa.question.title}`}
              {!qa.isVaild ? <span style={{ color: "#888" }}>（原文无法对应）</span> : null}
            </div>
          );
        })}
      </div>
    </div>
  );
};
