import { PID } from "@tingwu/core";

export interface Summary {
  id: string;
  agendaHeading: string;
  beginTime: number;
  endTime: number;
  content: string;
  star?: number;
  tag?: string[];
}

export interface AgendaSummaryStates {
  summaries: Summary[];
  pidSummariesMap: Record<PID, Summary[]>;
  readonly: boolean;
  isThreeUnitTime: boolean;
}

export const getAgendaSummaryInitState = (): AgendaSummaryStates => {
  return {
    summaries: [],
    pidSummariesMap: {},
    readonly: false,
    isThreeUnitTime: false,
  };
};
