import styled, { css } from "styled-components";

export const Wrapper = styled.div<{
  animated: boolean;
  done: boolean;
}>`
  transition:
    transform 0.5s,
    opacity 1s;
  overflow: hidden;
  transform: translateY(-50px);

  opacity: 0;

  ${props =>
    props.animated &&
    css`
      transform: translateY(0);
      opacity: 1;
    `}

  ${props =>
    props.done &&
    css`
      overflow: visible;
      transform: none;
    `}
`;
