import React, { memo } from "react";
import { Wrapper } from "./styled";
import { TYIcon } from "@tingwu/design";

export interface StarProps {
  active?: boolean;
  onMouseEnter?: () => void;
  onMouseLeave?: () => void;
  onMouseDown?: () => void;
  style?: React.CSSProperties;
}

export const Star: React.FC<StarProps> = memo(props => {
  const { active = false, onMouseEnter, onMouseLeave, onMouseDown, style } = props;

  return (
    <Wrapper
      active={active}
      onMouseEnter={onMouseEnter}
      onMouseLeave={onMouseLeave}
      onMouseDown={onMouseDown}
      style={style}
    >
      <TYIcon type={"tongyi-star-fill"} style={{ fontSize: 16 }} />
    </Wrapper>
  );
});
