import React, { memo } from "react";
import { Icon } from "@tingwu/meeting-icon";
import { Wrapper, Heading, Title, HeadingOperates, HeadingExtraContainer } from "./styled";

export interface SphereCardProps {
  showIcon?: boolean;
  title: React.ReactNode;
  headingExtra?: React.ReactNode;
  headingOperates?: React.ReactNode;
  content?: React.ReactNode;
  style?: React.CSSProperties;
  className?: string;
}

export const SphereCard: React.FC<SphereCardProps> = memo(props => {
  const {
    showIcon = true,
    title,
    headingExtra,
    headingOperates,
    content,
    style,
    className,
  } = props;
  return (
    <Wrapper className={className} style={style}>
      <Heading>
        <Title>
          {showIcon && <Icon type={"tingwu-AI"} size={20} />}
          {title}
        </Title>
        <HeadingExtraContainer>
          {headingOperates && (
            <HeadingOperates className={"sphereCard-headingOperates"}>
              {headingOperates}
            </HeadingOperates>
          )}
          {headingExtra && <div>{headingExtra}</div>}
        </HeadingExtraContainer>
      </Heading>
      {content}
    </Wrapper>
  );
});
