import React, { memo } from "react";
import { Tooltip, TYIcon } from "@tingwu/design";

export interface FeedbackOperateProps {
  onShowFeedback?: () => void;
}

export const FeedbackOperate: React.FC<FeedbackOperateProps> = memo(props => {
  const { onShowFeedback } = props;
  return (
    <Tooltip title="反馈" overlayClassName="tingwu2-tips">
      <TYIcon type={"extend-feedback-line"} className="icon-item" onClick={onShowFeedback} />
    </Tooltip>
  );
});
