import React, { memo, useCallback } from "react";
import { TYIcon } from "@tingwu/design";
import { Wrapper, Text, RedDot } from "./styled";

export interface ExpanderProps {
  expanded: boolean;
  onChange: (expanded: boolean) => void;
  expandText?: React.ReactNode;
  collapseText?: React.ReactNode;
  showRedDot?: boolean;
  prefix?: React.ReactNode;
}

export const Expander: React.FC<ExpanderProps> = memo(props => {
  const {
    expanded,
    onChange,
    prefix,
    expandText = "展开全部",
    collapseText = "收起",
    showRedDot = false,
  } = props;

  const onToggle = useCallback(() => {
    onChange(!expanded);
  }, [expanded, onChange]);

  return (
    <Wrapper expanded={expanded} onClick={onToggle}>
      {prefix}
      <Text>
        {!expanded ? expandText : collapseText}
        {showRedDot && <RedDot />}
      </Text>
      <TYIcon type={"tingwu-arrow-down"} style={{ fontSize: 16 }} />
    </Wrapper>
  );
});
