import styled from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  user-select: none;
`;

export const Avatar = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 26px;
  height: 26px;
  margin-right: -7px;
  border: 1px solid #f4f7fc;
  border-radius: 13px;
  box-shadow: -1px 0 10px -4px #605ce5;
  pointer-events: none;
  &:last-child {
    margin-right: 0;
  }
  > *:first-child {
    width: 100%;
    height: 100%;
    border-radius: 50%;
  }
`;

export const OmittedImage = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 100%;
  height: 100%;
  border-radius: 50%;
  background-color: #e2e1ff;
`;

export const OmittedPoint = styled.div`
  width: 2px;
  height: 2px;
  border-radius: 1px;
  background-color: rgba(39, 38, 77, 0.65);

  margin-right: 3px;
  :last-child {
    margin-right: 0;
  }
`;
