import React, { memo, useMemo } from "react";
import { SpeakerSummaryController } from "../../spheres";
import { useSphereState } from "../provider";
import { Wrapper, Avatar, OmittedImage, OmittedPoint } from "./styled";

export interface SpeakerGroupProps {
  speakerSummaryController: SpeakerSummaryController;
  style?: React.CSSProperties;
}

export const SpeakerGroup: React.FC<SpeakerGroupProps> = memo(props => {
  const { speakerSummaryController, style } = props;

  const displaySummaries = useSphereState(speakerSummaryController, "displaySummaries");
  const avatars = useMemo(() => {
    return (displaySummaries || []).map(summary => {
      return speakerSummaryController.renderSpeakerAvatar(summary, 24);
    });
  }, [displaySummaries, speakerSummaryController]);

  const speakerAvatars = [...avatars];
  // 第一个发言人头像不显示
  speakerAvatars.splice(0, 1);
  if (speakerAvatars.length === 0) {
    return null;
  }

  // 发言人头像最多显示三个，第4个显示省略号
  if (speakerAvatars.length >= 4) {
    speakerAvatars.splice(3);
    speakerAvatars.push(
      <OmittedImage>
        {Array(3)
          .fill(1)
          .map(() => (
            <OmittedPoint />
          ))}
      </OmittedImage>
    );
  }

  return (
    <Wrapper style={style}>
      {speakerAvatars.map(avatar => (
        <Avatar>{avatar}</Avatar>
      ))}
    </Wrapper>
  );
});
