import React from "react";
import { useSyncEffect } from "@tingwu/common";
import { SphereContext } from "../../base/sphereContext";
import { SphereAppContext } from "./context";

export interface ProviderProps {
  context: SphereContext;
  children: React.ReactNode;
}

export const Provider: React.FC<ProviderProps> = props => {
  const { context, children } = props;

  useSyncEffect(() => {}, []);

  return <SphereAppContext.Provider value={{ context }}>{children}</SphereAppContext.Provider>;
};
