import styled from "styled-components";

export const ListContain = styled.div`
  height: 100vh;
  width: 258px;
  background: rgba(0, 0, 0, 0.8);
  overflow: scroll;
  padding: 36px 40px 0;
  position: relative;
  scrollbar-width: none; /* firefox */
  -ms-overflow-style: none; /* IE 10+ */
  &::-webkit-scrollbar {
    display: none; /* Chrome Safari */
  }

  &::before {
    content: "";
    position: absolute;
    height: 100%;
    left: 0;
    right: 0;
    filter: blur(6px);
  }

  .PPTSlide__Agenda {
    margin-bottom: 16px;
  }
  .PPTSlide__AgendaTitle {
    max-height: 44px;
    font-family: PingFangSC var(--font-family);
    font-weight: 400;
    font-size: 14px;
    color: var(--Text_Primary);
    letter-spacing: 0;
    line-height: 22px;
    margin-bottom: 8px;
    overflow: hidden;
    -webkit-line-clamp: 2;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-box-orient: vertical;
    /* Tooltip */
    .ant-tooltip {
      max-width: 320px;
    }
    .ant-tooltip-arrow {
      transform: translateX(-98%) translateY(-50%);
    }
    .ant-tooltip-arrow-content {
      --antd-arrow-background-color: linear-gradient(to right bottom, #fff, #fff) !important;
    }
    .ant-tooltip-inner {
      background: var(--Text_Brand_Primary);
      color: var(--Text_Primary);
      padding: 8px 15px;
      font-family: PingFangSC var(--font-family);
      font-weight: 400;
      font-size: 12px;
      color: #27264d;
      letter-spacing: 0;
      line-height: 20px;
    }
  }
  .PPTSlide__PPT {
    position: relative;
    box-sizing: content-box;
    background-repeat: no-repeat;
    background-size: contain;
    background-position: center;
    background-color: var(--Fill_Brand_Tertiary);
    width: 178px;
    height: 100px;
    border-radius: 4px;
    margin-bottom: 12px;
    overflow: hidden;
    cursor: pointer;
    &:last-of-type {
      margin-bottom: 0;
    }

    &.ppt-active {
      border: 5px solid var(--Line_Heavy);
      border-radius: 4px;
      margin-left: -5px;
      margin-right: -5px;
    }
  }
`;
