import styled from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  align-items: center;
  /* min-width: 1280px; */
  position: fixed;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  z-index: 1000;
  overflow-x: auto;
  overflow-y: hidden;
  background: var(--Mask_Laptop);
  backdrop-filter: blur(6px);
  .close-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    position: absolute;
    right: 16px;
    top: 16px;
    cursor: pointer;
    color: var(--Text_White);
    height: 36px;
    width: 36px;
    background-color: var(--Fill_Tertiary);
    border-radius: 50%;
    &:hover {
      background-color: var(--Fill_Secondary);
    }
    &:active {
      background-color: var(--Fill_Secondary);
    }
  }
`;

export const RightCont = styled.div`
  /* flex: 1; */
  width: calc(100vw - 258px);
  min-width: 1022px; /** 1280 - 258px */
  height: 100%;
  padding: 86px 74px 86px 80px;
  background: var(--Mask_Laptop);
  position: relative;
  &::before {
    content: "";
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
    filter: blur(6px);
    z-index: -1;
  }
`;

export const ImgBox = styled.div`
  /* width: 100%;
  position: relative;
  flex: 1; */
  img {
    width: 100%;
    height: auto;
    display: block;
  }
`;
export const WrapOper = styled.div`
  flex: 1;
  display: flex;
  overflow: hidden;
  flex-direction: column;
  justify-content: space-between;
  height: 100%;
`;

// 顶部操作栏
export const TopNavStyle = styled.div`
  display: flex;
  justify-content: space-between;
  margin-bottom: 10px;
  .nav-right {
    color: var(--Text_White);
    display: flex;
    align-items: center;
    span {
      cursor: pointer;
      margin-right: 30px;
      display: inline-block;
      &:last-child {
        margin-right: 0;
      }
    }
    .down-file,
    .delete-img,
    .copy-data {
      padding: 5px 0;
      cursor: pointer;
      color: var(--Text_White);
      &:hover {
        color: var(--Fill_Brand_Tertiary);
      }
      &:active {
        color: var(--Fill_Brand_Tertiary);
      }
      span {
        position: relative;
        top: 2px;
      }
    }
    .no-down {
      svg {
        color: rgba(255, 255, 255, 0.3);
      }
    }
    .copy-data {
      padding-top: 7px;
    }
    .goback-look {
      cursor: pointer;
      display: inline-block;
      min-height: 32px;
      line-height: 20px;
      font-size: 12px;
      text-align: center;
      background: var(--Text_Brand_Primary);
      border-radius: 6px;
      font-weight: 500;
      &:hover {
        background-color: var(--Fill_Brand_Secondary);
      }
      &:active {
        background-color: var(--Fill_Brand_Secondary);
      }
      .goback-look-box {
        display: flex;
        padding: 6px 16px;
        color: var(--Text_White);
        span {
          margin-right: 4px;
          &:last-child {
            margin-right: 0;
          }
        }
      }
    }
  }
  .nav-left {
    opacity: 0.8;
    font-family: PingFangSC;
    font-weight: 600;
    font-size: 14px;
    color: var(--Text_White);
    letter-spacing: 0;
    line-height: 24px;
  }
`;
export const TopNavDown = styled.div`
  padding: 8px 0;
  color: var(--Text_Primary);
  background-color: var(--Fill_Background_Light);
  p {
    padding: 10px 16px;
    margin-bottom: 0;
    cursor: pointer;
    &:hover {
      background-color: var(--Fill_Background);
    }
  }
`;

export const BottomTextStyle = styled.div`
  .bottom-text {
    color: var(--Text_White);
    margin-top: 24px;
    opacity: 0.8;
    .text-loading {
      p {
        height: 12px;
        width: 100%;
        opacity: 0.27;
        background: linear-gradient(
          90deg,
          rgba(255, 255, 255, 0.6) 25%,
          rgba(255, 255, 255, 0.95) 37%,
          rgba(255, 255, 255, 0.6) 63%
        );
        background-size: 400% 100%;
        animation-name: text-loading-keyframes;
        animation-duration: 1.4s;
        animation-timing-function: ease;
        animation-iteration-count: infinite;
        margin-bottom: 16px;
        &:last-child {
          width: 50%;
          margin-bottom: 0;
        }
      }
    }
    @keyframes text-loading-keyframes {
      0% {
        background-position: 100% 50%;
      }
      100% {
        background-position: 0 50%;
      }
    }
  }
`;
