import React, { memo } from "react";
import { BottomTextStyle } from "../styled";
import { middleStatus } from "../untils/middleData";

interface IBottomT {
  text: string | undefined;
  isLoadingConten: boolean | undefined;
}

export const BottomText = memo((props: IBottomT) => {
  const { text, isLoadingConten } = props;
  return (
    <BottomTextStyle>
      <div className="bottom-text">
        {!middleStatus.noData ? (
          <>
            {isLoadingConten ? (
              <div className="text-loading">
                <p />
                <p />
              </div>
            ) : (
              text
            )}
          </>
        ) : null}
      </div>
    </BottomTextStyle>
  );
});
