import styled, { css } from "styled-components";

export const Wrapper = styled.div`
  user-select: none;
  &:hover {
    .agenda {
      background-color: rgba(96, 92, 229, 0.1);
    }
  }
`;

export const TopBar = styled.div`
  display: flex;
  justify-content: flex-end;
  align-items: flex-end;
  height: 30px;
  padding: 4px 0;
`;

export const Content = styled.div<{
  displayTimeWidth: number;
}>`
  display: grid;
  grid-template-columns: ${props => props.displayTimeWidth}px 7px 1fr;
  min-height: 50px;
`;

export const Time = styled.div<{
  isThreeUnitTime: boolean;
}>`
  font-size: 12px;
  color: #27264d;
  line-height: 16px;
  margin-top: 17px;

  ${props =>
    props.isThreeUnitTime &&
    css`
      text-align: right;
      padding-right: 12px;
    `}
`;

export const Line = styled.div`
  display: grid;
  grid-template-rows: 13px 7px 1fr;
  row-gap: 8.5px;
  position: relative;
`;

const BaseLine = styled.div<{
  visible?: boolean;
}>`
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAADCAYAAABS3WWCAAAAAXNSR0IArs4c6QAAAERlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAA6ABAAMAAAABAAEAAKACAAQAAAABAAAAAaADAAQAAAABAAAAAwAAAACD4s6eAAAAD0lEQVQIHWNIjH3WwwAHABriAjGjLvKkAAAAAElFTkSuQmCC");
  background-repeat: repeat-y;
  width: 1px;
  margin-left: 3px;
  overflow: hidden;
  ${props =>
    props.visible === false &&
    css`
      background-position: -9999px -9999px;
    `}
`;

export const LineOfDot = styled.div`
  width: 7px;
  height: 7px;
  border-radius: 7px;
  background-color: #605ce5;
`;

export const LineOfTop = BaseLine;

export const LineOfBottom = styled.div`
  width: 1px;
  margin-left: 3px;
  overflow: hidden;
  position: absolute;
  top: 37px;
  height: calc(100% - 37px);
`;

export const Agenda = styled.div`
  transition: all 0.25s;
  background-color: rgba(96, 92, 229, 0.05);
  border-radius: 4px;
  overflow: hidden;
  margin-left: 16px;
  padding: 12px 24px 12px 16px;
`;

export const AgendaHeading = styled.div`
  font-size: 14px;
  color: #27264d;
  line-height: 24px;
  -webkit-font-smoothing: antialiased;
  user-select: text;
  margin-bottom: 4px;
  white-space: pre-wrap;
  overflow-wrap: anywhere;
`;

export const AgendaSummary = styled.div`
  font-size: 12px;
  color: rgba(39, 38, 77, 0.65);
  /* text-align: justify; */
  line-height: 20px;
  user-select: text;
  white-space: pre-wrap;
  overflow-wrap: anywhere;
`;
