export interface IApiResponse<T = unknown> {
  code: string | number;
  data: T;
  message: string;
  success: boolean;
  total?: number;
  pageNo?: number;
  pageSize?: number;
}

// 听悟接口返回数据格式
export interface IRequestResult extends IApiResponse {
  code: string;
}

export enum eBigModelDataType {
  "labInfo" = "labInfo", // 大模型基础信息
  "labSummaryInfo" = "labSummaryInfo", // 大模型相关概览信息
  "labPptInfo" = "labPptInfo", // 大模型相关 PPT 信息
  "labQaInfo" = "labQaInfo",
}
