import axios from "axios";

export const isDevelopMent = false;
// 在 Vite 中使用 import.meta.env，在 Umi/Webpack 中使用 process.env
const getEnvValue = (key: string): string => {
  // 优先使用 process.env（兼容测试环境）
  if (typeof process !== "undefined" && process.env && process.env[key]) {
    return process.env[key] || "";
  }
  // Vite 环境（import.meta.env）- 仅在非测试环境使用
  // 使用 eval 来避免在测试环境中解析错误
  try {
    // @ts-ignore - import.meta 在测试环境中可能不可用
    const importMeta = eval('typeof import !== "undefined" ? import.meta : undefined');
    if (importMeta && importMeta.env && (importMeta.env as any)[key]) {
      return (importMeta.env as any)[key];
    }
  } catch (e) {
    // import.meta 在测试环境中不可用，忽略错误
  }
  return "";
};

export const API_KEY = getEnvValue("REACT_APP_API_KEY");
export const APP_ID = getEnvValue("REACT_APP_APP_ID");
export const websocketUrl = "wss://dashscope.aliyuncs.com/api-ws/v1/inference";

const defaultUrl = "/api/services/aigc/multimodal-generation/generation";

const axiosInstance = axios.create({
  withCredentials: true,
  headers: {
    Authorization: `Bearer ${API_KEY}`,
    "Content-Type": "application/json",
  },
  params: {},
});

export const getResultRequest = (url: string) => {
  return axios
    .create()
    .get(url)
    .then(res => {
      console.log(res);
      return res.data;
    })
    .catch(err => {
      return err;
    });
};
const request = {
  get: (params?: any) => {
    return axiosInstance
      .get(defaultUrl, { params })
      .then(res => {
        return res.data;
      })
      .catch(err => {
        return err;
      });
  },
  post: (data: any, url?: string) => {
    return axiosInstance
      .post(url || defaultUrl, data)
      .then(res => {
        return res.data;
      })
      .catch(err => {
        return err;
      });
  },
};

export default request;
