// Jest config for tingwu-service package
// This extends the root jest config
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  // Override rootDir to be relative to this package
  rootDir: path.resolve(__dirname, '../..'),
  // Only run tests for this package
  testMatch: ['<rootDir>/packages/tingwu-service/**/__tests__/**/*.test.{ts,tsx}'],
  // Setup files
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  // Module name mapper
  moduleNameMapper: {
    ...rootConfig.moduleNameMapper,
    // Handle axios mocking
    '^axios$': require.resolve('axios'),
  },
  // Transform configuration for ts-jest
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      tsconfig: {
        module: 'esnext',
        moduleResolution: 'node',
        esModuleInterop: true,
        allowSyntheticDefaultImports: true,
      },
    }],
  },
};

