# @tingwu/service

听悟项目 API 服务层，提供 HTTP 请求封装和 API 调用功能。

## 📦 安装

```bash
npm install @tingwu/service
```

## 🎯 功能特性

- **HTTP 请求封装**: 统一的 HTTP 请求接口
- **API 调用**: 封装各种业务 API 调用
- **请求拦截器**: 请求和响应拦截处理
- **错误处理**: 统一的错误处理机制

## 📖 使用示例

```typescript
import request, { getTokens, websocketUrl } from '@tingwu/service';

// 发送 GET 请求
const getData = await request.get({ param: 'value' });

// 发送 POST 请求
const postData = await request.post({ key: 'value' }, '/api/endpoint');

// 获取临时 token
const tokens = await getTokens();

// 使用 WebSocket URL
const wsUrl = `${websocketUrl}?api_key=${tokens.token}`;
```

## 🔧 开发

```bash
# 安装依赖
npm install

# 构建
npm run build

# 类型检查
npm run typechecking

# 代码检查
npm run lint
```

## 📄 许可证

[GPL-3.0-or-later](../../LICENSE)

