import React, { memo } from "react";
import { IconContainer, IconSvg } from "./styled";
import { loadIcon } from "./iconfont";

interface IconProps extends Omit<React.HTMLProps<HTMLSpanElement>, "ref" | "as"> {
  type: string;
  viewBox?: string;
  size?: number;
  color?: string;
  spin?: boolean;
  rotate?: number;
}

export const Icon = memo((props: IconProps) => {
  const { type, viewBox, size, color, spin, rotate = 0, className = "", ...rest } = props;

  React.useEffect(() => {
    loadIcon();
  }, []);

  return (
    <IconContainer className={`tingwu-icon ${className}`} size={size} {...rest}>
      <IconSvg
        className={spin ? "tingwu-icon-spin" : ""}
        viewBox={viewBox}
        fill={color || "currentColor"}
        rotate={rotate}
        aria-hidden="true"
      >
        <use xlinkHref={`#${type}`} />
      </IconSvg>
    </IconContainer>
  );
});
