import { createBrowserRouter } from "react-router-dom";

import { ExperienceCenter } from "./pages/ExperienceCenter";

// 兼容测试环境，避免 import.meta 报错
let basename: string | undefined;
try {
  // @ts-ignore - import.meta 在测试环境中可能不可用
  basename = typeof import.meta !== 'undefined' ? import.meta.env?.BASE : undefined;
} catch (e) {
  // import.meta 在测试环境中不可用，使用默认值
  basename = undefined;
}

const router = createBrowserRouter(
  [
    {
      path: "/",
      element: <ExperienceCenter />,
    },
  ],
  {
    basename: basename,
  }
);

export default router;
