import React, { FC, useMemo, useRef, useState } from "react";
import {
  EnterControl,
  eTranscriptionStatusType,
  TranscribedSuccess,
  TranscriptionFailed,
  Transcribing,
  iEnterControlRefType,
} from "./components";
import { ConfigProvider } from "antd";
import styles from "./index.module.less";
import { expTheme, FailedMapTable } from "../../constant";
import { merge } from "lodash-es";
import { TYProvider } from "@tingwu/design";

export const initErrorInfo = FailedMapTable[0];

const theme = merge({}, expTheme);
const ExperienceCenter: FC = () => {
  const [currStatus, setCurrStatus] = useState<eTranscriptionStatusType>(
    eTranscriptionStatusType.WAITING
  );
  const [errorInfo, setErrorInfo] = useState(initErrorInfo);
  const EnterControlRef = useRef<iEnterControlRefType>(null);

  const renderTranscriptionStatus = useMemo(() => {
    if (currStatus === eTranscriptionStatusType.WAITING) return null;
    let Content = null;
    switch (currStatus) {
      case eTranscriptionStatusType.ERROR:
        Content = (
          <TranscriptionFailed
            onTryAgainHandler={() => {
              if (!EnterControlRef.current) return;
              EnterControlRef.current.onTryAgainHandler();
            }}
            description={errorInfo.message}
            canRetry={errorInfo.canRetry}
          />
        );
        break;
      case eTranscriptionStatusType.SUCCESS:
        Content = <TranscribedSuccess />;
        break;
      case eTranscriptionStatusType.TRANSCRIBING:
        Content = <Transcribing />;
        break;
      default:
        break;
    }
    return <div className={styles.TranscriptionStatusWrapper}>{Content}</div>;
  }, [currStatus, errorInfo]);
  return (
    <TYProvider
      {...theme}
      // iconfont="https://at.alicdn.com/t/a/font_4807885_6wjcpzayws6.js"
      // className="appRoot"
    >
      <div className={styles.ExperienceCenter}>
        <div className={styles.ExperienceCenter__Content}>
          <div className={styles.ExperienceCenter__Content__Wrapper}>
            <EnterControl
              setErrorInfo={setErrorInfo}
              setCurrStatus={setCurrStatus}
              ref={EnterControlRef}
            />
          </div>

          {renderTranscriptionStatus}
        </div>
      </div>
    </TYProvider>
  );
};

const memoWrapper = React.memo(ExperienceCenter);

export { memoWrapper as ExperienceCenter };
