// *** 三方库 ***
import React, { FC, useEffect, useState } from "react";
import { Flex } from "antd";
import styles from "./index.module.less";
import { ErrorCircleFill } from "@tingwu/components";

export interface iTranscriptionFailedPropsType {
  className?: string;
  style?: React.CSSProperties;
  title?: string;
  description?: string;
  onTryAgainHandler?: () => void;
  canRetry: boolean;
}
const TranscriptionFailed: FC<iTranscriptionFailedPropsType> = props => {
  const {
    className = "",
    style = {},
    title = "生成失败",
    description = "系统出错了，请重试",
    onTryAgainHandler = () => {},
    canRetry = true,
  } = props;

  const [visible, setVisible] = useState(false);

  useEffect(() => {
    // 组件挂载后触发opacity动画
    const timer = setTimeout(() => {
      setVisible(true);
    }, 0);

    return () => clearTimeout(timer);
  }, []);

  return (
    <div className={`${styles.TranscriptionFailed} ${className}`} style={style}>
      <Flex
        vertical
        gap={8}
        align="center"
        justify="center"
        className={styles.TranscriptionFailed__Content}
        style={{ opacity: visible ? 1 : 0 }}
      >
        <div className={styles.TranscriptionFailed__Img}>
          <img
            src="https://img.alicdn.com/imgextra/i4/O1CN01KPo9SI1CzCtUQCwNK_!!6000000000151-2-tps-2385-680.png"
            alt=""
            className={styles.TranscriptionFailed__Img__Content}
          />
        </div>
        <div className={styles.TranscriptionFailed__Title}>
          <Flex justify="center" align="center" gap={8}>
            <ErrorCircleFill style={{ color: "rgba(255, 77, 79, 1)" }} />
            {title}
          </Flex>
        </div>
        <div className={styles.TranscriptionFailed__Description}>
          {description}
          {canRetry ? (
            <span className={styles.TryAgain} onClick={onTryAgainHandler}>
              重试
            </span>
          ) : null}
        </div>
      </Flex>
    </div>
  );
};

const memoWrapper = React.memo(TranscriptionFailed);

export { memoWrapper as TranscriptionFailed };
