import React from 'react';
import { render } from '@testing-library/react';
import { ExperienceCenter } from '../pages/ExperienceCenter';

// Suppress console.error for React warnings in tests
const originalError = console.error;
beforeAll(() => {
  console.error = jest.fn();
});

afterAll(() => {
  console.error = originalError;
});

// Mock dependencies
jest.mock('@tingwu/design', () => ({
  TYProvider: ({ children }: { children: React.ReactNode }) => <div>{children}</div>,
}));

jest.mock('antd', () => ({
  ConfigProvider: ({ children }: { children: React.ReactNode }) => <div>{children}</div>,
}));

// Mock EnterControl with forwardRef to support ref
jest.mock('../pages/ExperienceCenter/components', () => {
  const React = require('react');
  return {
    EnterControl: React.forwardRef((props: any, ref: any) => {
      // Expose methods that might be called via ref
      React.useImperativeHandle(ref, () => ({
        onTryAgainHandler: jest.fn(),
      }));
      return <div>EnterControl</div>;
    }),
    TranscribedSuccess: () => <div>TranscribedSuccess</div>,
    TranscriptionFailed: () => <div>TranscriptionFailed</div>,
    Transcribing: () => <div>Transcribing</div>,
    eTranscriptionStatusType: {
      WAITING: 'WAITING',
      TRANSCRIBING: 'TRANSCRIBING',
      SUCCESS: 'SUCCESS',
      ERROR: 'ERROR',
    },
  };
});

describe('@tingwu/home - ExperienceCenter', () => {
  it('should export ExperienceCenter component', () => {
    expect(ExperienceCenter).toBeDefined();
  });

  it('should render ExperienceCenter without crashing', () => {
    const { container } = render(<ExperienceCenter />);
    expect(container).toBeTruthy();
  });
});

