// Jest config for tingwu-home package
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  rootDir: path.resolve(__dirname, '../..'),
  testMatch: ['<rootDir>/packages/tingwu-home/**/__tests__/**/*.test.{ts,tsx}'],
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      // Use test-specific tsconfig that includes type declarations
      tsconfig: require.resolve('./tsconfig.test.json'),
    }],
  },
  moduleNameMapper: {
    ...rootConfig.moduleNameMapper,
    '\\.(less|css)$': 'identity-obj-proxy',
    // Map lodash-es to lodash (CommonJS) for testing
    '^lodash-es$': 'lodash',
    '^lodash-es/(.*)$': 'lodash/$1',
  },
  // Transform lodash-es to handle ES modules
  transformIgnorePatterns: [
    'node_modules/(?!(lodash-es)/)',
  ],
};

