import { defineConfig } from "vite";
import react from "@vitejs/plugin-react";
import path from "path";
import os from "os";

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [react()],
  // 支持 REACT_APP_ 前缀的环境变量
  envPrefix: ["VITE_", "REACT_APP_"],
  // 从项目根目录读取 .env 文件
  envDir: path.resolve(__dirname, "../.."),
  // 使用临时目录作为缓存，避免权限问题
  cacheDir: path.resolve(os.tmpdir(), "tingwu-example-vite"),
  resolve: {
    alias: {
      "@": path.resolve(__dirname, "./src"),
    },
  },
  server: {
    port: 3000,
    open: true,
    host: true,
    proxy: {
      "/api": {
        target: "https://dashscope.aliyuncs.com/api/v1",
        changeOrigin: true,
        secure: false,
        rewrite: path => path.replace(/^\/api/, ""),
      },
    },
  },
  build: {
    outDir: "dist",
    sourcemap: true,
  },
  optimizeDeps: {
    include: ["react", "react-dom", "antd", "@ant-design/icons"],
  },
});
