import { createGlobalStyle } from "styled-components";
import { tyButtonWrapperCls } from "../Button/styled";

export const tyModalCls = "ty-modal";

export const ModalInjectStyle = createGlobalStyle`body, html {
    ${`.${tyModalCls}`} {
      &.ant-modal .ant-modal-content {
        border-radius: 24px;
        box-shadow: 0 8px 12px 0 rgba(0, 0, 0, 0.12);
        padding: 40px 40px 44px;
        background-color: var(--Fill_Background_Light);
        .ant-modal-header {
          .ant-modal-title {
            color: var(--Text_Primary);
          }
        }
      }

      &.ant-modal-confirm .ant-modal-confirm-body >.anticon {
        font-size: 24px;
        margin-inline-end: 8px;
        position: relative;
        top: -1px;
      }

      &.ant-modal-confirm-success .ant-modal-confirm-body>.anticon {
        color: var(--Success_Clicked);
      }

      &.ant-modal-confirm-error .ant-modal-confirm-body>.anticon {
        color: var(--Danger_Clicked);
      }

      &.ant-modal-confirm-info .ant-modal-confirm-body>.anticon {
        color: var(--Processing_Clicked);
      }

      &.ant-modal-confirm-warning .ant-modal-confirm-body>.anticon,
      &.ant-modal-confirm-confirm .ant-modal-confirm-body>.anticon {
        color: var(--Warning_Clicked);
      }

      &.ant-modal-confirm .ant-modal-confirm-paragraph {
        row-gap: 1rem;
      }

      &.ant-modal-confirm .ant-modal-confirm-title {
        font-size: 23px;
        font-weight: 600;
        line-height: 24px;
        color: var(--Text_Primary);
      }

      &.ant-modal-confirm .ant-modal-confirm-content {
        font-size: 13px;
        font-weight: normal;
        line-height: 24px;
        color: var(--Text_Primary);
      }
      &.ant-modal-confirm .ant-modal-confirm-btns {
        margin-top: 24px;
        text-align: start;
        .ty-button-danger-wrapper {
          flex-direction: row-reverse;
          display: flex;
          justify-content: flex-end;
        }
      }
      &.ant-modal .ant-modal-footer ${`.${tyButtonWrapperCls}`} {
        .ant-btn + .ant-btn {
          margin-inline-start: 8px;
        }
      }

      &.ant-modal .ant-modal-header {
        margin-bottom: 20px;
        background: transparent;
      }

      &.ant-modal .ant-modal-footer {
        margin-top: 20px;
      }

      .ant-modal-close .closeIcon,
      .ant-modal-close .anticon-close {
        color: var(--Text_Primary);
      }

      .ant-modal-close:hover .closeIcon,
      .ant-modal-close:hover .anticon-close {
        color: var(--Text_Disabled);
      }
      .ant-modal-close:hover {
        background-color: transparent;
      }
    }
    /** 样式补全部分 **/
    .ant-modal-confirm .ant-modal-confirm-body {
      display: flex;
      flex-wrap: nowrap;
      align-items: start;
    }
    .ant-modal-confirm .ant-modal-confirm-btns {
      text-align: end;
    }
    .ant-modal-confirm-paragraph {
      max-width: calc(100% - 34px);
      display: flex;
      flex-direction: column;
      flex: auto;
    }
    .ant-modal-confirm .ant-modal-confirm-btns .ant-btn:first-child {
      margin-bottom: 0;
      margin-left: 8px;
    }
    .ant-modal-confirm .ant-modal-confirm-btns .ant-btn+.ant-btn {
      margin-inline-start: 0;
    }
    .ant-modal-root .ant-modal-mask {
      position: fixed;
      inset: 0;
      z-index: 1000;
      height: 100%;
      background-color: var(--Mask_Laptop);
      pointer-events: none;
    }
  }
`;
