import { createGlobalStyle } from "styled-components";
// import { myRoot } from '../../../util/constant';

export const tyMessageCls = "ty-message";
export const MessageInjectStyle = createGlobalStyle`
  .ant-message {
    color: rgba(0, 0, 0, 0.88);
    font-size: 14px;
    line-height: 1.5714285714285714;
    list-style: none;
    font-family: "PingFang SC";
    z-index: 2010;
    width: fit-content;
    margin-top: 48px;
    .ant-message-notice-wrapper {
      padding: 8px;
      text-align: center;
    }
  }
  .ty-spin-icon {
    .anticon-spin::before, .anticon-spin {
      animation-duration: 2s;
    }
  }
  .ant-message .ant-message-notice-wrapper .ant-message-notice-content {
    display: inline-block;
    padding: 12px;
    background: var(--Fill_White);
    border-radius: 16px;
    box-shadow: 0px 2px 2px 0px rgba(0, 0, 0, 0.1);
    pointer-events: all;
  }
  body:not(.ty-message-body-hidden) {${`.${tyMessageCls}`} {
    & {
      font-size: 14px;
      line-height: 24px;
      color: var(--Text_Primary);
    }
    .ant-message-notice-content {
      padding: 12px 16px !important;
      box-shadow: 0px 2px 2px 0px rgba(0, 0, 0, 0.1) !important;
      border-radius: 16px !important;
      display: inline-block !important;
      background-color: var(--Fill_Tertiary) !important;
      color: var(--Text_Primary) !important;
    }
    .ant-message-custom-content > .anticon {
      font-size: 20px !important;
      /* position: relative !important;
      top: 2px !important; */
    }
    .ant-message-success > .anticon {
      color: var(--Success_Clicked) !important;
    }
    .ant-message-info > .anticon {
      color: var(--Processing_Clicked) !important;
    }
    .ant-message-warning > .anticon {
      color: var(--Warning_Clicked) !important;
    }
    .ant-message-error > .anticon {
      color: var(--Danger_Clicked) !important;
    }
    .and-message-loading > .anticon {
      color: var(--Processing_Clicked) !important;
    }
  }}
`;
