import { Input as AntdInput, InputProps, InputRef } from "antd";
import { GroupProps } from "antd/es/input/Group";
import { PasswordProps } from "antd/es/input/Password";
import { SearchProps } from "antd/es/input/Search";
import { TextAreaProps, TextAreaRef } from "antd/es/input/TextArea";
import classNames from "classnames";
import React, { forwardRef } from "react";
import { TYIcon } from "../../TYIcon";
import { tyInputCls, tyTransparentBgInputCls } from "./styled";

export type { InputRef } from "antd";
export type { PasswordProps } from "antd/es/input/Password";
export type { SearchProps } from "antd/es/input/Search";
export type { TextAreaProps, TextAreaRef } from "antd/es/input/TextArea";

const InternalInput = forwardRef<InputRef, InputProps & { transparentBg?: boolean }>(
  (props, ref) => {
    const { className, transparentBg, ...restProps } = props;
    return (
      <AntdInput
        className={classNames(tyInputCls, { [tyTransparentBgInputCls]: transparentBg }, className)}
        ref={ref}
        {...restProps}
      />
    );
  }
);

const TextArea = forwardRef<TextAreaRef, TextAreaProps>((props, ref) => {
  const { className, ...restProps } = props;
  return (
    <AntdInput.TextArea className={classNames(tyInputCls, className)} ref={ref} {...restProps} />
  );
});

const Password = forwardRef<InputRef, PasswordProps>((props, ref) => {
  const { className, ...restProps } = props;
  return (
    <AntdInput.Password className={classNames(tyInputCls, className)} ref={ref} {...restProps} />
  );
});

const Search = forwardRef<InputRef, SearchProps>((props, ref) => {
  const { className, ...restProps } = props;
  return (
    <AntdInput
      ref={ref}
      className={classNames(tyInputCls, className)}
      prefix={
        <TYIcon
          type="tongyi-search-line"
          style={{
            fontSize: 20,
            color: "var(--Text_Primary)",
          }}
        />
      }
      {...restProps}
    />
  );
});

const Group = (props: GroupProps) => {
  const { className, size, ...restProps } = props;
  // console.log('never use size', size);

  return <AntdInput className={classNames(tyInputCls, className)} {...restProps} />;
};

const { OTP } = AntdInput;

type CompoundedComponent = typeof InternalInput & {
  Group: typeof Group;
  Search: typeof Search;
  TextArea: typeof TextArea;
  Password: typeof Password;
  OTP: typeof OTP;
};

const Input = InternalInput as CompoundedComponent;

Input.Group = Group;
Input.Search = Search;
Input.TextArea = TextArea;
Input.Password = Password;
Input.OTP = OTP;
export { Input };
