import React from "react";
import { Dropdown as AntdDropdown, DropdownProps } from "antd";
import { DropdownButtonProps } from "antd/es/dropdown";
import { tyDropdownCls } from "./styled";
import classNames from "classnames";

export type { DropdownProps } from "antd";

const InternalDropdown = (props: DropdownProps) => {
  return <AntdDropdown {...props} overlayClassName={classNames(tyDropdownCls, props.className)} />;
};

const Button = (props: DropdownButtonProps) => {
  return <AntdDropdown.Button {...props} />;
};

type CompoundedComponent = typeof InternalDropdown & {
  _InternalPanelDoNotUseOrYouWillBeFired: typeof AntdDropdown._InternalPanelDoNotUseOrYouWillBeFired;
} & {
  Button: typeof Button;
};

export const Dropdown = InternalDropdown as CompoundedComponent;
Dropdown.Button = Button;

/* eslint-disable no-underscore-dangle */
Dropdown._InternalPanelDoNotUseOrYouWillBeFired =
  AntdDropdown._InternalPanelDoNotUseOrYouWillBeFired;
/* eslint-enable no-underscore-dangle */
