import React from "react";
import { Checkbox as AntdCheckbox, CheckboxProps } from "antd";
import classNames from "classnames";
import { tyCheckboxCls, tyCheckboxGroupCls } from "./styled";

export const Checkbox = (props: CheckboxProps) => {
  const { className, ...restProps } = props;
  return <AntdCheckbox className={classNames(tyCheckboxCls, className)} {...restProps} />;
};

type CheckboxGroupProps = Parameters<typeof AntdCheckbox.Group>[0];

Checkbox.Group = (props: CheckboxGroupProps) => {
  const { className, ...restProps } = props;
  return (
    <AntdCheckbox.Group className={classNames(tyCheckboxGroupCls, className)} {...restProps} />
  );
};
