import { createGlobalStyle, css } from "styled-components";

export const tyButtonCls = "ty-button";
export const tyButtonWrapperCls = "ty-button-wrapper";
export const tyButtonDangerWrapperCls = "ty-button-danger-wrapper";

const tyBtnStyle = css`
  display: inline-flex !important;
  align-items: center !important;
  justify-content: center;
  border: none;
  height: 48px !important;
  border-radius: 12px !important;
  padding: 12px 20px !important;
  background: var(--Fill_Heavy);
  box-shadow: none;
  color: var(--Text_White);
  &.ant-btn.ant-btn-circle {
    border-radius: 50% !important;
  }
  &.ant-btn:not(:disabled):focus-visible {
    outline: none;
  }

  &.ant-btn-sm {
    padding: 6px 12px !important;
    font-size: 13px;
    height: 36px !important;
  }

  &.ant-btn.ant-btn-icon-only {
    width: 36px;
  }

  &.ant-btn .anticon,
  &.ant-btn.ant-btn-icon-only .anticon {
    font-size: 20px;
  }

  &.ant-btn-primary {
    background-color: var(--Fill_Brand_Inverse);
    color: var(--Text_Brand_Primary);
    box-shadow: none;
    border: none;
  }

  &.ant-btn-primary:not(:disabled):not(.ant-btn-disabled):hover,
  &.ant-btn-primary:not(:disabled):not(.ant-btn-disabled):active {
    background-color: var(--Fill_Brand_Primary);
    color: var(--Text_Brand_Primary);
  }

  &.ant-btn-text,
  &.ant-btn-link {
    background-color: transparent;
    color: var(--Text_Primary);
    box-shadow: none;
    border: none;
  }

  &.ant-btn-text:not(:disabled):not(.ant-btn-disabled):hover,
  &.ant-btn-text:not(:disabled):not(.ant-btn-disabled):active,
  &.ant-btn-link:not(:disabled):not(.ant-btn-disabled):hover,
  &.ant-btn-link:not(:disabled):not(.ant-btn-disabled):hover {
    color: var(--Text_Primary);
    background: transparent;
  }

  &.ant-btn-text:disabled,
  &.ant-btn-text.ant-btn-disabled,
  &.ant-btn-link:disabled,
  &.ant-btn-link.ant-btn-disabled {
    color: var(--Fill_Secondary);
  }

  &.ant-btn-primary:disabled,
  &.ant-btn-primary.ant-btn-disabled {
    background-color: var(--Fill_Brand_Background) !important;
    border: none;
    color: var(--Fill_Transparent_Light) !important;
    box-shadow: none;
  }

  &.ant-btn-primary.ant-btn-dangerous {
    background-color: var(--Danger_Clicked);
    color: var(--Text_White);
  }

  &.ant-btn-primary.ant-btn-dangerous:not(:disabled):not(.ant-btn-disabled):hover,
  &.ant-btn-primary.ant-btn-dangerous:not(:disabled):not(.ant-btn-disabled):active {
    background-color: var(--Danger_Default);
  }

  &.ant-btn-primary.ant-btn-dangerous:disabled,
  &.ant-btn-primary.ant-btn-dangerous.ant-btn-disabled {
    background-color: var(--Danger_Disabled);
    border-color: var(--Danger_Disabled);
    box-shadow: none;
  }

  &.ant-btn-default {
    border: none;
    background-color: var(--Fill_Tertiary);
    box-shadow: none;
    color: var(--Text_Primary);
    &:not(:disabled):not(.ant-btn-disabled):hover,
    &:not(:disabled):not(.ant-btn-disabled):active {
      color: var(--Text_Primary);
      background: var(--Fill_Background);
      box-shadow: none;
    }
  }

  &.ant-btn-default:disabled,
  &.ant-btn-default.ant-btn-disabled {
    background: var(--Fill_Brand_Background);
    border: none;
    color: var(--Fill_Transparent_Light);
  }

  &.ant-btn-default.ant-btn-dangerous {
    background: var(--Danger_Background);
    color: var(--Text_Danger);
  }

  &.ant-btn-default.ant-btn-dangerous:not(:disabled):not(.ant-btn-disabled):hover,
  &.ant-btn-default.ant-btn-dangerous:not(:disabled):not(.ant-btn-disabled):active {
    background-color: var(--Danger_Disabled);
  }
  &.ant-btn-default.ant-btn-dangerous:disabled,
  &.ant-btn-default.ant-btn-dangerous.ant-btn-disabled {
    background: var(--Danger_Background);
    color: var(--Danger_Disabled);
  }
`;

export const ButtonInjectStyle = createGlobalStyle`body, html {
  ${`.${tyButtonWrapperCls}`} .ant-btn, ${`.${tyButtonCls}`} {
    ${tyBtnStyle}
  }
  ${`.${tyButtonDangerWrapperCls}`} {
    .ant-btn {
      &.ant-btn-primary {
        background-color: var(--Fill_Brand_Inverse);
        border: none;
        color: var(--Text_Brand_Primary); 
      }

      &.ant-btn-primary:not(:disabled):not(.ant-btn-disabled):hover,
      &.ant-btn-primary:not(:disabled):not(.ant-btn-disabled):active {
        background-color: var(--Fill_Brand_Primary);
      }
    }
  }}
`;
