import React from "react";
import { TyCss, TyCssOnce, TYTokenColorVars } from "./styled";
import { StyleProvider, legacyLogicalPropertiesTransformer } from "@ant-design/cssinjs";
import { App } from "antd";
// import { setInternalMessage, setInternalModal } from '../antdOverride';

export interface TYProviderProps {
  children: React.ReactNode;
}

// const InternalAntdRegister = () => {
//   const { message, modal } = App.useApp();

//   useEffect(() => {
//     setInternalMessage(message);
//     setInternalModal(modal);
//     return () => {
//       setInternalMessage(undefined);
//       setInternalModal(undefined);
//     };
//   }, [message, modal]);

//   return null;
// };

export const TYProvider = (props: TYProviderProps) => {
  const { children } = props;
  // const isHrefLoc = !location.host.includes(':'); // host含: 认为是本地环境； 该变量认为是非本地（预发、线上）
  // let renderTokenInner = false;
  // if (isHrefLoc) {
  //   renderTokenInner = false; // 预发、线上环境 强制不渲染 token
  // } else {
  //   renderTokenInner = renderToken;
  // }
  return (
    <StyleProvider hashPriority="high" transformers={[legacyLogicalPropertiesTransformer]}>
      <App style={{ height: "100%", width: "100%" }}>
        <TyCss />
        <TYTokenColorVars />
        {/* <InternalAntdRegister /> */}
        {children}
      </App>
    </StyleProvider>
  );
};

export { TyCss, TyCssOnce };
