import styled, { css } from "styled-components";

export type LoadingType =
  | "wireframeWhite"
  | "wireframePurple"
  | "wireframeBlack"
  | "textured"
  | "solid";

const DEFAULT_LOADING_TYPE = "solid";

const LOGO =
  "https://img.alicdn.com/imgextra/i4/O1CN01LmLrun1ud4pHMcxPq_!!6000000006059-55-tps-45-27.svg";

function getLoadingType(type?: LoadingType) {
  return type || DEFAULT_LOADING_TYPE;
}

function isLoadingType(type: LoadingType | undefined, target: LoadingType) {
  return getLoadingType(type) === target;
}

function getSize(size: number | undefined) {
  return size;
}

export const Loading = styled.div<{
  size?: number;
  type?: LoadingType;
}>`
  background-size: contain;
  background-repeat: no-repeat;
  ${props => css`
    width: ${getSize(props.size) || 45}px;
    height: ${getSize(props.size) || 27}px;
  `}

  ${props =>
    isLoadingType(props.type, "wireframeWhite") &&
    css`
      background-image: url(${LOGO});
    `}

  ${props =>
    isLoadingType(props.type, "wireframePurple") &&
    css`
      background-image: url("https://img.alicdn.com/imgextra/i3/O1CN01RjewLp28VCXBneeWl_!!6000000007937-54-tps-72-72.apng");
    `}

  ${props =>
    isLoadingType(props.type, "wireframeBlack") &&
    css`
      background-image: url(${LOGO});
    `}

  ${props =>
    isLoadingType(props.type, "textured") &&
    css`
      background-image: url(${LOGO});
    `}

  ${props =>
    isLoadingType(props.type, "solid") &&
    css`
      background-image: url(${LOGO});
    `}
`;
