import styled from "styled-components";

export const FullScreen = styled.div`
  width: 100%;
  height: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
`;

export const Wrapper = styled.div`
  display: flex;
  flex-direction: column;
  width: 500px;
  overflow: hidden;
  align-items: center;
`;

export const Image = styled.div`
  width: 100px;
  height: 100px;
  background-repeat: no-repeat;
  background-size: contain;
  background-position: center center;
`;

export const Title = styled.div`
  font-family: "PingFang SC";
  font-size: 17px;
  font-weight: 500;
  line-height: 28px;
  color: var(--Text_Primary);
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  margin-top: 17px;
`;

export const Description = styled.div`
  font-family: "PingFang SC";
  font-size: 15px;
  line-height: 24px;
  color: var(--Text_Secondary);
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  margin-top: 4px;
`;
