import { SC, Word } from "../persist";

const getUniqueId = (() => {
  let id = 10000;
  return () => {
    return `W${++id}`;
  };
})();

export const getWordBySc = (sc: SC): Word => {
  return {
    wid: sc.id != null ? String(sc.id) : getUniqueId(),
    beginTime: sc.bt,
    endTime: sc.et,
    sentenceId: String(sc.si),
    text: sc.tc,
    tag: sc.tag?.mark || "",
    nFix: sc.pt === 1,
  };
};

export const getWordsBySces = (sces: SC[]): Word[] => {
  return sces.map(sc => getWordBySc(sc));
};
