import { isEqual } from "lodash-es";
import { Point } from "./point";
import { Range } from "./range";

export class Selection {
  static create(range: Range) {
    const selection = new Selection(range);
    return selection;
  }

  static createByStart(point: Point) {
    const range = new Range({ start: point, end: point });
    return Selection.create(range);
  }

  readonly range: Range;

  constructor(range: Range) {
    this.range = range;
  }

  endBy(point: Point) {
    this.range.end = point;
  }

  isCaret() {
    const { start, end } = this.range;
    return isEqual(start, end);
  }
}
