import { PID } from "../persist";

export interface PointModel {
  pid: PID;
  offset: number;
  edge?: "before" | "after";
  isUnfix?: boolean;
}

export class Point {
  static create(pid: PID, offset: number, edge: "before" | "after" = "after", isUnfix = false) {
    const point = new Point(pid, offset, edge, isUnfix);
    return point;
  }

  static fromJSON(model: PointModel) {
    return Point.create(model.pid, model.offset, model.edge, model.isUnfix);
  }

  pid: PID;

  offset: number;

  edge: "before" | "after";

  isUnfix = false;

  constructor(pid: PID, offset: number, edge: "before" | "after", isUnfix = false) {
    this.pid = pid;
    this.offset = offset;
    this.edge = edge;
    this.isUnfix = isUnfix;
  }
}
