import { AnyOperation, PID, UID, WID, Word } from "../../persist";
import { Range, Selection } from "../../editor";

export interface Hooks {
  beforeApply: (isSilent: boolean, extPayload?: any) => void;
  afterApply: (
    change: AnyOperation[],
    inverse: AnyOperation[],
    nextSelection: Selection | undefined,
    isSilent: boolean,
    isNextPreteat: boolean
  ) => void;
}

export interface Book {
  insertText: (pid: PID, startOffset: number, text: string) => void;
  insertTextAndAddParagraph: (pid: PID, startOffset: number, text: string) => void;
  deleteTextRange: (range: Range) => void;
  addParagraph: (prevPid: PID, newPid: PID, startOffset: number) => void;
  mergeParagraph: (prevPid: PID, pid: PID) => void;
  removeParagraph: (pid: PID) => void;
  addUnfixParagraph: (pid: PID, uid: UID, targetWids?: WID[]) => void;
  addFixParagraph: (pid: PID, targetWids?: WID[], selection?: Selection) => void;
  appendWords: (pid: PID, words: Word[], willFix?: boolean) => void;
  updateExistWords: (words: Word[]) => void;
  setParagraphMark: (pid: PID, tagColor: string) => void;
  updateUserByPid: (pid: PID, uid: UID) => void;
  updateAllUsers: (pids: PID[], uid: UID) => void;
  updateParagraphWords: (paragraphWords: Map<PID, Word[]>, attrs: Partial<Word>) => void;
}

export interface Setter {
  apply: (change: AnyOperation[], nextSelection?: Selection, extPayload?: any) => void;
  nextApplyPreteat: () => void;
  nextApplySilent: () => void;
  book: Book;
}
