import { Controller } from "../index";
import { demoCheckpoint } from "../../persist/demo";

describe("voiceWord", () => {
  const controller = new Controller();
  controller.setModelValue(demoCheckpoint);
  it("prevSentences", () => {
    const target = [
      {
        beginTime: 13750,
        endTime: 14125,
        sentenceId: "1",
        tag: "blue",
        text: "谢谢",
        wid: "10",
      },
      {
        beginTime: 14125,
        endTime: 14500,
        sentenceId: "1",
        tag: "",
        text: "于老",
        wid: "20",
      },
      {
        beginTime: 14500,
        endTime: 14875,
        sentenceId: "1",
        tag: "",
        text: "师介",
        wid: "30",
      },
      {
        beginTime: 14875,
        endTime: 15250,
        sentenceId: "1",
        tag: "",
        text: "绍，",
        wid: "40",
      },
      {
        beginTime: 15251,
        endTime: 15640,
        sentenceId: "1",
        tag: "",
        text: "这一",
        wid: "50",
      },
      {
        beginTime: 15640,
        endTime: 16029,
        sentenceId: "1",
        tag: "",
        text: "介绍",
        wid: "60",
      },
      {
        beginTime: 16029,
        endTime: 16418,
        sentenceId: "1",
        tag: "",
        text: "之后，",
        wid: "70",
      },
      {
        beginTime: 16418,
        endTime: 16710,
        sentenceId: "1",
        tag: "",
        text: "搞得",
        wid: "80",
      },
      {
        beginTime: 16710,
        endTime: 17002,
        sentenceId: "1",
        tag: "",
        text: "我更",
        wid: "90",
      },
      {
        beginTime: 17002,
        endTime: 17294,
        sentenceId: "1",
        tag: "",
        text: "加紧",
        wid: "100",
      },
      {
        beginTime: 17294,
        endTime: 17586,
        sentenceId: "1",
        tag: "",
        text: "张。",
        wid: "110",
      },
    ];

    const prevSentences = controller.getPrevSentencesByTime(20921);
    expect(prevSentences).toMatchObject(target);
  });

  it("prevSentences", () => {
    const target = [
      {
        beginTime: 24757,
        endTime: 25114,
        sentenceId: "3",
        tag: "",
        text: "因为",
        wid: "300",
      },
      {
        beginTime: 25114,
        endTime: 25471,
        sentenceId: "3",
        tag: "",
        text: "最主",
        wid: "310",
      },
      {
        beginTime: 25471,
        endTime: 25828,
        sentenceId: "3",
        tag: "",
        text: "要本",
        wid: "320",
      },
      {
        beginTime: 25828,
        endTime: 26185,
        sentenceId: "3",
        tag: "",
        text: "来说",
        wid: "330",
      },
      {
        beginTime: 26185,
        endTime: 26542,
        sentenceId: "3",
        tag: "",
        text: "跟俞",
        wid: "340",
      },
      {
        beginTime: 26542,
        endTime: 26899,
        sentenceId: "3",
        tag: "",
        text: "老师",
        wid: "350",
      },
      {
        beginTime: 26899,
        endTime: 27256,
        sentenceId: "3",
        tag: "",
        text: "说，",
        wid: "360",
      },
      {
        beginTime: 27259,
        endTime: 27583,
        sentenceId: "3",
        tag: "",
        text: "我希",
        wid: "370",
      },
      {
        beginTime: 27583,
        endTime: 27907,
        sentenceId: "3",
        tag: "",
        text: "望能",
        wid: "380",
      },
      {
        beginTime: 27907,
        endTime: 28231,
        sentenceId: "3",
        tag: "",
        text: "够这",
        wid: "390",
      },
      {
        beginTime: 28231,
        endTime: 28555,
        sentenceId: "3",
        tag: "",
        text: "个学",
        wid: "400",
      },
      {
        beginTime: 28555,
        endTime: 28879,
        sentenceId: "3",
        tag: "",
        text: "期能",
        wid: "410",
      },
      {
        beginTime: 28879,
        endTime: 29203,
        sentenceId: "3",
        tag: "",
        text: "够做",
        wid: "420",
      },
      {
        beginTime: 29203,
        endTime: 29527,
        sentenceId: "3",
        tag: "",
        text: "一篇",
        wid: "430",
      },
      {
        beginTime: 29527,
        endTime: 29851,
        sentenceId: "3",
        tag: "",
        text: "好一",
        wid: "440",
      },
      {
        beginTime: 29851,
        endTime: 30175,
        sentenceId: "3",
        tag: "",
        text: "点的",
        wid: "450",
      },
      {
        beginTime: 30175,
        endTime: 30499,
        sentenceId: "3",
        tag: "",
        text: "文章，",
        wid: "460",
      },
      {
        beginTime: 30504,
        endTime: 30756,
        sentenceId: "3",
        tag: "",
        text: "然后",
        wid: "470",
      },
      {
        beginTime: 30756,
        endTime: 31008,
        sentenceId: "3",
        tag: "",
        text: "过来",
        wid: "480",
      },
      {
        beginTime: 31008,
        endTime: 31260,
        sentenceId: "3",
        tag: "",
        text: "讲一",
        wid: "490",
      },
      {
        beginTime: 31260,
        endTime: 31512,
        sentenceId: "3",
        tag: "",
        text: "讲。",
        wid: "500",
      },
    ];

    const prevSentences = controller.getNextSentencesByTime(20921);
    expect(prevSentences).toMatchObject(target);
  });
});
