import { Controller } from "../index";
import {
  normalNFixFrame,
  paragraphNormalAllFrame,
  paragraphNormalBreakFrame,
} from "./mock/biaodianParagraph.data";

describe("nfixBreakParagraph", () => {
  it("breaking：测试成段时，才会修正文本", async () => {
    const controller = new Controller();
    controller.setLivingMode(true);
    controller.injectSpeakersGetter(() => []);
    controller.injectSpeakersSetter(() => {});
    controller.on("paragraphChangeSpecific", event => {
      event.addParagraphPids.forEach(() => {
        // console.log('------- event', controller.getParagraph(pid));
      });
    });

    // 处理初始数据：word 5710 文本为 "计算，"
    controller.processParagraphFrames(normalNFixFrame);
    const word1 = controller.getWord("5710");
    expect(word1).toBeDefined();
    expect(word1?.text).toEqual("计算，");

    // 完整段落，但未成段：word 5710 文本应该还是 "计算，"
    // 注意：paragraphNormalAllFrame 中 word 5710 的文本是 "计算。"，但由于是 partial: true，
    // 只会追加新词，不会修改已有词，所以 word 5710 应该保持 "计算，"
    controller.processParagraphFrames(paragraphNormalAllFrame);
    const word2 = controller.getWord("5710");
    expect(word2).toBeDefined();
    // 由于是 partial: true，已有词不会被更新，所以应该还是 "计算，"
    expect(word2?.text).toEqual("计算，");

    // 触发强制成段：word 5710 文本应该变成 "计算。"
    // 注意：paragraphNormalBreakFrame 中第一个 frame 是 partial: false，会成段并修正标点
    controller.processParagraphFrames(paragraphNormalBreakFrame);
    const word3 = controller.getWord("5710");
    expect(word3).toBeDefined();
    expect(word3?.text).toEqual("计算。");

    await new Promise(r => setTimeout(r, 2000));
  });
});
