# @tingwu/core

听悟项目核心逻辑模块，提供文档编辑、控制器、数据模型等核心功能。

## 📦 安装

```bash
npm install @tingwu/core
```

## 🎯 功能特性

- **控制器**: 文档操作控制器（文本、段落、说话人、搜索替换等）
- **数据模型**: 文档数据模型和操作
- **持久化**: 数据持久化相关功能
- **编辑器**: 编辑器核心功能（选择、范围、光标等）
- **工具函数**: 文本处理、段落处理、报告生成等工具

## 📖 使用示例

```typescript
import { 
  Controller,
  Word,
  SID,
  PID,
  Eventes,
  Paragraph,
  Speaker 
} from '@tingwu/core';

// 使用核心类型和工具
const word: Word = {
  // word 数据结构
};

const speakerId: SID = 'speaker-1';
const paragraphId: PID = 'paragraph-1';

// 使用控制器
const controller = new Controller();

// 使用事件
Eventes.on('event', (data) => {
  console.log(data);
});
```

## 🔧 开发

```bash
# 安装依赖
npm install

# 构建
npm run build

# 类型检查
npm run typechecking

# 代码检查
npm run lint
```

## 📄 许可证

[GPL-3.0-or-later](../../LICENSE)

